// supabase/functions/initialize-payment
import { serve } from 'https://deno.land/std@0.168.0/http/server.ts';
import { createClient } from 'https://esm.sh/@supabase/supabase-js@2';

serve(async (req) => {
  const { plan, email, userId } = await req.json();
  
  // In a real app, you would:
  // 1. Verify the user is authenticated
  // 2. Create a Paystack transaction reference
  // 3. Return the Paystack public key and reference
  
  return new Response(JSON.stringify({
    publicKey: Deno.env.get('PAYSTACK_PUBLIC_KEY'),
    reference: `ref_${Date.now()}`,
    amount: plan === 'pro' ? 290000 : 0 // in kobo
  }), {
    headers: { 'Content-Type': 'application/json' },
  });
});