// webcrypto-polyfill.ts
if (typeof window !== 'undefined' && !window.crypto) {
  // Simple polyfill for testing environments
  (window as any).crypto = {
    getRandomValues: function(buffer: any) {
      for (let i = 0; i < buffer.length; i++) {
        buffer[i] = Math.floor(Math.random() * 256);
      }
      return buffer;
    },
    subtle: {
      digest: function(algorithm: string, data: Uint8Array) {
        return Promise.resolve(new Uint8Array(20)); // Simple mock
      }
    }
  } as any;
  
  console.log('WebCrypto polyfill applied');
}