// Example in Next.js API route (/pages/api/verify-payment.js)
import { supabase } from '@/lib/supabase';
import axios from 'axios';

export default async function handler(req, res) {
  if (req.method !== 'POST') {
    return res.status(405).json({ message: 'Method not allowed' });
  }

  const { reference, userId } = req.body;

  try {
    // Verify with Paystack API
    const response = await axios.get(
      `https://api.paystack.co/transaction/verify/${reference}`,
      {
        headers: {
          Authorization: `Bearer ${process.env.PAYSTACK_SECRET_KEY}`,
        },
      }
    );

    if (response.data.data.status === 'success') {
      // Update user subscription in Supabase
      const { error } = await supabase
        .from('subscriptions')
        .upsert({
          user_id: userId,
          plan: response.data.data.metadata.plan,
          status: 'active',
          payment_reference: reference,
          starts_at: new Date().toISOString(),
          ends_at: new Date(new Date().setMonth(new Date().getMonth() + 1)).toISOString()
        });

      if (error) throw error;

      return res.status(200).json({ success: true });
    }

    return res.status(400).json({ success: false, message: 'Payment not successful' });
  } catch (error) {
    console.error('Verification error:', error);
    return res.status(500).json({ success: false, message: 'Payment verification failed' });
  }
}