import './webcrypto-polyfill';
import React from 'react';
import ReactDOM from 'react-dom/client';
import { createRoot } from 'react-dom/client';
import './index.css';
import App from './App.tsx';
import { SessionContextProvider } from '@supabase/auth-helpers-react';
import { supabase } from './supabaseClient';

const container = document.getElementById('root');
if (!container) throw new Error('Root container not found');

const root = createRoot(container); // ✅ call this only once

root.render(
  <SessionContextProvider supabaseClient={supabase}>
    <App />
  </SessionContextProvider>
);
