// PaymentPage.tsx
import { useSearchParams } from "react-router-dom";

const PaymentPage = () => {
  const [searchParams] = useSearchParams();
  const module = searchParams.get("module") || "basic";

  const displayText = {
    pro: "Pro Module includes advanced reports, permissions, and analytics.",
    odt: "Organization Development Toolkit unlocks user roles and insights.",
    default: "Upgrade to unlock premium features."
  };

  const description = displayText[module as keyof typeof displayText] || displayText.default;

  return (
    <div className="p-8">
      <h1 className="text-2xl font-bold mb-4">Upgrade: {module.toUpperCase()} Module</h1>
      <p>{description}</p>

      {/* Optional: Render module-specific pricing or options */}
      {/* Add Stripe or payment logic here */}
    </div>
  );
};

export default PaymentPage;
