// components/InviteManager.tsx
import React, { useEffect, useState } from 'react';
import { supabase } from '../supabaseClient';

const InviteManager: React.FC = () => {
  const [invites, setInvites] = useState<any[]>([]);

  useEffect(() => {
    fetchInvites();
  }, []);

  const fetchInvites = async () => {
    const { data, error } = await supabase
      .from('organization_invites')
      .select('*')
      .order('created_at', { ascending: false });
    
    if (!error && data) setInvites(data);
  };

  const copyInviteLink = (token: string, email: string) => {
    const link = `${window.location.origin}/auth?invite=${token}&email=${encodeURIComponent(email)}`;
    navigator.clipboard.writeText(link);
    alert('Invite link copied!');
  };

  return (
    <div>
      <h2>Pending Invites</h2>
      {invites.map(invite => (
        <div key={invite.id}>
          <p>{invite.email} - {invite.role}</p>
          <button onClick={() => copyInviteLink(invite.token, invite.email)}>
            Copy Invite Link
          </button>
        </div>
      ))}
    </div>
  );
};

export default InviteManager;