import React from "react";
import { motion } from "framer-motion";
import { Button } from "@/components/ui/button";
import { Link } from "react-router-dom";
import Logo from "@/assets/logo.png";
import TrackerGraphic from "@/assets/tracker.jpg";
import { Card } from "@/components/ui/card";
import { Target, Zap, Crown, Check } from "lucide-react";

const Hero = () => {
  return (
    <>
      <section className="relative w-full min-h-[105vh] flex items-center justify-center bg-gradient-to-br from-purple-700 via-purple-700 to-purple-700 text-white overflow-hidden">
        {/* Decorative blurred circles */}
        <div className="absolute top-10 left-10 w-48 h-48 bg-purple-700/30 rounded-full blur-3xl animate-pulse" />
        <div className="absolute bottom-20 right-16 w-72 h-72 bg-purple-700/20 rounded-full blur-3xl animate-pulse" />

        {/* Floating graphics */}
        <motion.img
          src={TrackerGraphic}
          alt="Development Tools Graphic"
          className="absolute hidden md:block bottom-0 left-0 w-60 opacity-70"
          initial={{ opacity: 0, x: -100, y: 50 }}
          animate={{ opacity: 0.8, x: 0, y: 0 }}
          transition={{ duration: 1.2, ease: "easeOut" }}
        />
        <motion.img
          src={TrackerGraphic}
          alt="Development Tools Graphic"
          className="absolute hidden md:block top-0 right-0 w-56 opacity-60"
          initial={{ opacity: 0, x: 100, y: -50 }}
          animate={{ opacity: 0.8, x: 0, y: 0 }}
          transition={{ duration: 1.2, ease: "easeOut", delay: 0.3 }}
        />

        <motion.div
          className="relative z-10 max-w-4xl px-6 text-center flex flex-col items-center"
          initial={{ opacity: 0, y: 50 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.9, ease: "easeOut" }}
        >
          <motion.img
            src={Logo}
            alt="App Logo"
            className="w-24 h-24 mb-6 drop-shadow-xl"
            initial={{ scale: 0.8, opacity: 0 }}
            animate={{ scale: 1, opacity: 1 }}
            transition={{ duration: 0.6, ease: "easeOut" }}
          />

          <h1 className="text-4xl md:text-6xl font-bold mb-4 leading-tight">
            Track Your Growth with <span className="text-yellow-300">DTT</span>
          </h1>

          <p className="text-lg md:text-xl text-white/90 mb-8 max-w-2xl">
            Your personal development companion.  
            Set goals, monitor progress, and unlock your full potential with our development tracking tools.
          </p>

          <div className="flex justify-center gap-4 flex-wrap">
            <Link to="/Auth">
              <Button size="lg" className="bg-yellow-400 text-black hover:bg-yellow-300">
                Get Started
              </Button>
            </Link>
          </div>
        </motion.div>
      </section>

    
    </>
  );
};

export default Hero;
